
// Not finished, please don't steal it till I'm done.

class HealingGun extends PulseGun;

#exec TEXTURE IMPORT NAME=HGMuzzyPulse FILE=Textures\HGMuzzyPulse.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=HGAmmoLed FILE=Textures\HGAmmoLed.bmp GROUP=Skins

#exec MESHMAP SETTEXTURE MESHMAP=PulseGunL NUM=1 TEXTURE=HGAmmoled
#exec MESHMAP SETTEXTURE MESHMAP=PulseGunR NUM=1 TEXTURE=HGAmmoled


#exec AUDIO IMPORT FILE="Sounds\HGgundown.wav" NAME="HGgundown"
#exec AUDIO IMPORT FILE="Sounds\HGaltfire.wav" NAME="HGaltfire"
#exec AUDIO IMPORT FILE="Sounds\HGpickup.wav" NAME="HGpickup"
#exec AUDIO IMPORT FILE="Sounds\HGgunup.wav" NAME="HGgunup"
#exec AUDIO IMPORT FILE="Sounds\HGPulseFire.wav" NAME="HGPulseFire"

#exec TEXTURE IMPORT NAME=HGIconPulse FILE=TEXTURES\HGIconPulse.bmp GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=HGUsePulse FILE=TEXTURES\HGUsePulse.bmp GROUP="Icons" MIPS=OFF

var float Angle, Count;
var HGPBolt PlasmaBeam;
var() sound DownSound;

simulated event RenderOverlays( canvas Canvas )
{
    Texture'Ammoled'.NotifyActor = Self;
    Super.RenderOverlays(Canvas);
    Texture'Ammoled'.NotifyActor = None;
}

simulated function PostRender(Canvas C)
{
	Super.PostRender(C);
	DrawPlayerName(C);
}

simulated function DrawPlayerName(Canvas C)
{
	local float Dist;
	local PlayerPawn P;
	local int XPos, YPos;
	local Vector X,Y,Z, Dir;
	local PlayerPawn C_Owner;

	C_Owner = PlayerPawn(Owner);
	GetAxes(C_Owner.Rotation, X, Y, Z);

	if (Level.bHighDetailMode)
		C.Style = ERenderStyle.STY_Translucent;
	else
		C.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'PlayerPawn', P, 3000, C_Owner.Location, true)
        {
                if(P.Health > 200 )
			{
				C.DrawColor.R = 0;
				C.DrawColor.G = 0;
				C.DrawColor.B = 255;
			}
	        else
			{
			   if (P.Health > 100 )
                           {
				C.DrawColor.R = 255;
				C.DrawColor.G = 255;
				C.DrawColor.B = 0;
			   }

			   else
                           {
				C.DrawColor.R = 255;
				C.DrawColor.G = 0;
				C.DrawColor.B = 0;
			   }
			}

		Dir = P.Location - C_Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		if ((Dir Dot X) > 0.7) 
                {
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(XPos - 8, YPos - 8);
			C.DrawIcon(Texture'CrossHair5', 1.0);
			C.SetPos(Xpos - 12, YPos - 16);
			C.Font = C.SmallFont;
			C.SetPos(Xpos - 12, YPos - 16);
			C.DrawText("("$P.Health$")", true);
		}
	}
}

simulated function Destroyed()
{
    if ( PlasmaBeam != None )
        PlasmaBeam.Destroy();
    Super.Destroyed();
}

simulated function AnimEnd()
{
    if ( (Level.NetMode == NM_Client) && (Mesh != PickupViewMesh) )
    {
        if ( AnimSequence == 'SpinDown' )
            AnimSequence = 'Idle';
        PlayIdleAnim();
    }
}

function setHand(float Hand)
{
    if ( Hand == 2 )
    {
        FireOffset.Y = 0;
        bHideWeapon = true;
        if ( PlasmaBeam != None )
            PlasmaBeam.bCenter = true;
        return;
    }
    else
        bHideWeapon = false;
    PlayerViewOffset = Default.PlayerViewOffset * 100;
    if ( Hand == 1 )
    {
        if ( PlasmaBeam != None )
        {
            PlasmaBeam.bCenter = false;
            PlasmaBeam.bRight = false;
        }
        FireOffset.Y = Default.FireOffset.Y;
        Mesh = mesh(DynamicLoadObject("Botpack.PulseGunL", class'Mesh'));
    }
    else
    {
        if ( PlasmaBeam != None )
        {
            PlasmaBeam.bCenter = false;
            PlasmaBeam.bRight = true;
        }
        FireOffset.Y = -1 * Default.FireOffset.Y;
        Mesh = mesh'PulseGunR';
    }
}

simulated function PlayFiring()
{
    FlashCount++;
    AmbientSound = FireSound;
    SoundVolume = Pawn(Owner).SoundDampening*255;
    LoopAnim( 'shootLOOP', 1 + 0.5 * FireAdjust, 0.0);
    bWarnTarget = (FRand() < 0.2);
}

simulated function PlayAltFiring()
{
    
    AmbientSound = AltFireSound;
    if ( (AnimSequence == 'BoltLoop') || (AnimSequence == 'BoltStart') )        
        PlayAnim( 'boltloop');
    else
        PlayAnim( 'boltstart' );
}

state NormalFire
{
    ignores AnimEnd;

    function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
    {
        local Vector Start, X,Y,Z;

        Owner.MakeNoise(Pawn(Owner).SoundDampening);
        GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
        Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
        AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, Start, AimError, True, bWarn);   
        Start = Start - Sin(Angle)*Y*4 + (Cos(Angle)*4 - 10.78)*Z;
        Angle += 1.8;
        return Spawn(ProjClass,,, Start,AdjustedAim);   
    }

    function Tick( float DeltaTime )
    {
        if (Owner==None) 
            GotoState('Pickup');
    }

    function BeginState()
    {
        Super.BeginState();
        Angle = 0;
        AmbientGlow = 200;
    }

    function EndState()
    {
        PlaySpinDown();
        AmbientSound = None;
        AmbientGlow = 0;    
        OldFlashCount = FlashCount; 
        Super.EndState();
    }

Begin:
    Sleep(0.18);
    Finish();
}

simulated function PlaySpinDown()
{
    if ( (Mesh != PickupViewMesh) && (Owner != None) )
    {
        PlayAnim('Spindown', 1.0, 0.0);
        Owner.PlayOwnedSound(DownSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);
    }
}   

state ClientFiring
{
    simulated function Tick( float DeltaTime )
    {
        if ( (Pawn(Owner) != None) && (Pawn(Owner).bFire != 0) )
            AmbientSound = FireSound;
        else
            AmbientSound = None;
    }

    simulated function AnimEnd()
    {
        if ( (AmmoType != None) && (AmmoType.AmmoAmount <= 0) )
        {
            PlaySpinDown();
            GotoState('');
        }
        else if ( !bCanClientFire )
            GotoState('');
        else if ( Pawn(Owner) == None )
        {
            PlaySpinDown();
            GotoState('');
        }
        else if ( Pawn(Owner).bFire != 0 )
            Global.ClientFire(0);
        else if ( Pawn(Owner).bAltFire != 0 )
            Global.ClientAltFire(0);
        else
        {
            PlaySpinDown();
            GotoState('');
        }
    }
}


function AltFire( float Value )
{
    if ( AmmoType == None )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }
    if (AmmoType.UseAmmo(1))
    {
        GotoState('AltFiring');
        bCanClientFire = true;
        bPointing=True;
        Pawn(Owner).PlayRecoil(FiringSpeed);
        ClientAltFire(value);
        if ( PlasmaBeam == None )
        {
            PlasmaBeam = HGPBolt(ProjectileFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget));
            if ( FireOffset.Y == 0 )
                PlasmaBeam.bCenter = true;
            else if ( Mesh == mesh'PulseGunR' )
                PlasmaBeam.bRight = false;
        }
    }
}

simulated event RenderTexture(ScriptedTexture Tex)
{
    local Color C;
    local string Temp;
    
    Temp = String(AmmoType.AmmoAmount);

    while(Len(Temp) < 3) Temp = "0"$Temp;

    Tex.DrawTile( 30, 100, (Min(AmmoType.AmmoAmount,AmmoType.Default.AmmoAmount)*196)/AmmoType.Default.AmmoAmount, 10, 0, 0, 1, 1, Texture'AmmoCountBar', False );

    if(AmmoType.AmmoAmount < 10)
    {
        C.R = 255;
        C.G = 0;
        C.B = 0;    
    }
    else
    {
        C.R = 255;
        C.G = 0;
        C.B = 0;
    }

    Tex.DrawColoredText( 56, 14, Temp, Font'LEDFont', C );  
}

state ClientAltFiring
{
    simulated function AnimEnd()
    {
        if ( AmmoType.AmmoAmount <= 0 )
        {
            PlayIdleAnim();
            GotoState('');
        }
        else if ( !bCanClientFire )
            GotoState('');
        else if ( Pawn(Owner) == None )
        {
            PlayIdleAnim();
            GotoState('');
        }
        else if ( Pawn(Owner).bAltFire != 0 )
            LoopAnim('BoltLoop');
        else if ( Pawn(Owner).bFire != 0 )
            Global.ClientFire(0);
        else
        {
            PlayIdleAnim();
            GotoState('');
        }
    }
}

state AltFiring
{
    ignores AnimEnd;

    function Tick(float DeltaTime)
    {
        local Pawn P;

        P = Pawn(Owner);
        if ( P == None )
        {
            GotoState('Pickup');
            return;
        }
        if ( (P.bAltFire == 0) || (P.IsA('Bot')
                    && ((P.Enemy == None) || (Level.TimeSeconds - Bot(P).LastSeenTime > 5))) )
        {
            P.bAltFire = 0;
            Finish();
            return;
        }

        Count += Deltatime;
        if ( Count > 0.24 )
        {
            if ( Owner.IsA('PlayerPawn') )
                PlayerPawn(Owner).ClientInstantFlash( InstFlash,InstFog);
            if ( Affector != None )
                Affector.FireEffect();
            Count -= 0.24;
            if ( !AmmoType.UseAmmo(1) )
                Finish();
        }
    }
    
    function EndState()
    {
        AmbientGlow = 0;
        AmbientSound = None;
        if ( PlasmaBeam != None )
        {
            PlasmaBeam.Destroy();
            PlasmaBeam = None;
        }
        Super.EndState();
    }

Begin:
    AmbientGlow = 200;
    FinishAnim();   
    LoopAnim( 'boltloop');
}

simulated function PlayIdleAnim()
{
    if ( Mesh == PickupViewMesh )
        return;

    if ( (AnimSequence == 'BoltLoop') || (AnimSequence == 'BoltStart') )
        PlayAnim('BoltEnd');        
    else if ( AnimSequence != 'SpinDown' )
        TweenAnim('Idle', 0.1);
}

simulated function TweenDown()
{
    if ( IsAnimating() && (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
        TweenAnim( AnimSequence, AnimFrame * 0.4 );
    else
        TweenAnim('Down', 0.26);
}

function SetWeaponStay()
{
    bWeaponStay = false;
}


defaultproperties
{
     RespawnTime=1000.000000
     InstFlash=-0.15
     InstFog=(X=139.00000,Y=218.00000,Z=72.00000)
     DownSound=Sound'HGgundown'
     AmmoName=Class'Botpack.PAmmo'
     PickupAmmoCount=60
     bRapidFire=True
     FireOffset=(X=15.000000,Y=-15.000000,Z=2.000000)
     ProjectileClass=Class'HGPlasmaSphere'
     AltProjectileClass=Class'HGStarterbolt'
     shakemag=135.000000
     shakevert=8.000000
     AIRating=0.700000
     RefireRate=0.950000
     AltRefireRate=0.990000
     FireSound=Sound'HGPulseFire'
     AltFireSound=Sound'PulseBolt2'
     MessageNoAmmo=" has no Plasma."
     DeathMessage="%o ate %k's burning plasma death."
     FlashLength=0.020000
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got a Healing Gun"
     ItemName="Healing Gun"
     PlayerViewOffset=(X=1.500000,Z=-2.000000)
     PlayerViewMesh=LodMesh'Botpack.PulseGunR'
     PickupViewMesh=LodMesh'Botpack.PulsePickup'
     ThirdPersonMesh=LodMesh'Botpack.PulseGun3rd'
     ThirdPersonScale=0.400000
     StatusIcon=Texture'HGUsePulse'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzPF3'
     MuzzleFlashScale=0.40000
     MuzzleFlashTexture=Texture'HGMuzzyPulse'
     PickupSound=Sound'HGpickup'
     SelectSound=Sound'HGgunup'
     Icon=Texture'HGUsePulse'
     Mesh=LodMesh'Botpack.PulsePickup'
     bNoSmooth=False
     SoundRadius=64
     SoundVolume=255
     CollisionRadius=32.0
     WeaponDescription="Classification: Plasma Rifle\\n\\nPrimary Fire: Medium sized, fast moving plasma balls are fired at a fast rate of fire.\\n\\nSecondary Fire: A bolt of red is expelled for 100 meters, which will heal all teammates.\\n\\nTechniques: Firing and keeping the secondary fire's beam on a teammate will heal them in seconds."
     NameColor=(R=128,G=255,B=128)
}


